/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.scarab;

import com.github.teamfusion.rottencreatures.common.level.entities.scarab.ScarabFlyingGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Scarab
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.defineId(Scarab.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_LANDING = SynchedEntityData.defineId(Scarab.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(Scarab.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private GroundPathNavigation groundNavigation;
    private FlyingPathNavigation flyingNavigation;
    private int flyingTime = 0;
    private int jumpDelay = 0;
    private int landingTime = 0;
    private static final int LANDING_DURATION = 10;
    private static final int EMBELLISHED_FLIGHT_CHANCE = 15;
    private static final int DEFAULT_FLIGHT_CHANCE = 1;

    public Scarab(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new BeetleMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_FLYING, (Object)false);
        builder.define(DATA_IS_LANDING, (Object)false);
        builder.define(DATA_VARIANT, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BeetleMeleeAttackGoal(this, 1.25, false));
        this.goalSelector.addGoal(2, (Goal)new ScarabFlyingGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BeetleRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected PathNavigation createNavigation(Level level) {
        if (this.isFlying()) {
            if (this.flyingNavigation == null) {
                this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
                this.flyingNavigation.setCanOpenDoors(false);
                this.flyingNavigation.setCanFloat(true);
                this.flyingNavigation.setCanPassDoors(true);
            }
            return this.flyingNavigation;
        }
        if (this.groundNavigation == null) {
            this.groundNavigation = new GroundPathNavigation((Mob)this, level);
            this.groundNavigation.setCanOpenDoors(false);
            this.groundNavigation.setCanFloat(true);
            this.groundNavigation.setCanPassDoors(true);
        }
        return this.groundNavigation;
    }

    public void tick() {
        super.tick();
        if (this.isLanding()) {
            ++this.landingTime;
            if (this.landingTime >= 10) {
                this.setLanding(false);
                this.landingTime = 0;
            }
        }
        if (this.isFlying() && this.onGround() && !this.isLanding()) {
            this.setLanding(true);
            this.setFlying(false);
        }
        if (this.isFlying()) {
            int maxFlyingTime;
            ++this.flyingTime;
            int n = maxFlyingTime = this.isEmbellished() ? 400 : 200;
            if (this.flyingTime > maxFlyingTime && this.random.nextInt(100) < 10 && !this.isAggressive()) {
                this.setLanding(true);
                this.setFlying(false);
                this.flyingTime = 0;
            }
            if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
            }
        } else if (!this.isLanding() && this.onGround()) {
            int flightChance;
            int n = flightChance = this.isEmbellished() ? 15 : 1;
            if (--this.jumpDelay <= 0 && !this.isAggressive() && this.random.nextInt(100) < flightChance) {
                this.setFlying(true);
                this.jumpDelay = this.isEmbellished() ? 100 + this.random.nextInt(200) : 300 + this.random.nextInt(300);
                this.push(0.0, 0.4, 0.0);
            }
            if (this.getTarget() != null) {
                int combatFlightChance;
                int n2 = combatFlightChance = this.isEmbellished() ? 20 : 3;
                if (this.random.nextInt(100) < combatFlightChance) {
                    this.setFlying(true);
                }
            }
        }
    }

    public boolean isLanding() {
        return (Boolean)this.entityData.get(DATA_IS_LANDING);
    }

    public void setLanding(boolean landing) {
        this.entityData.set(DATA_IS_LANDING, (Object)landing);
    }

    public boolean isEmbellished() {
        return (Integer)this.entityData.get(DATA_VARIANT) == 1;
    }

    public void setVariant(int variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(DATA_IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(DATA_IS_FLYING, (Object)flying);
        this.navigation = this.createNavigation(this.level());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsFlying", this.isFlying());
        tag.putBoolean("IsLanding", this.isLanding());
        tag.putInt("Variant", ((Integer)this.entityData.get(DATA_VARIANT)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFlying(tag.getBoolean("IsFlying"));
        this.setLanding(tag.getBoolean("IsLanding"));
        this.setVariant(tag.contains("Variant") ? tag.getInt("Variant") : 0);
    }

    protected SoundEvent getAmbientSound() {
        return this.isFlying() ? SoundEvents.BEE_LOOP : SoundEvents.SILVERFISH_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SILVERFISH_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SILVERFISH_DEATH;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    static class BeetleMoveControl
    extends MoveControl {
        private final Scarab scarab;

        public BeetleMoveControl(Scarab scarab) {
            super((Mob)scarab);
            this.scarab = scarab;
        }

        public void tick() {
            if (this.scarab.isLanding()) {
                super.tick();
                return;
            }
            if (this.scarab.isFlying()) {
                if (this.operation == MoveControl.Operation.MOVE_TO) {
                    double dz;
                    double dy;
                    this.operation = MoveControl.Operation.WAIT;
                    double dx = this.wantedX - this.scarab.getX();
                    double distSq = dx * dx + (dy = this.wantedY - this.scarab.getY()) * dy + (dz = this.wantedZ - this.scarab.getZ()) * dz;
                    if (distSq < 2.5E-7) {
                        this.mob.setZza(0.0f);
                        return;
                    }
                    float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                    double dist = Math.sqrt(distSq);
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(dx / dist * 0.1 * (double)speed, dy / dist * 0.1 * (double)speed + 0.05, dz / dist * 0.1 * (double)speed));
                    this.mob.setYRot((float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f);
                    this.mob.setYBodyRot(this.mob.getYRot());
                    Vec3 movement = this.mob.getDeltaMovement();
                    double maxSpeed = (double)speed * 0.5;
                    if (movement.horizontalDistanceSqr() > maxSpeed * maxSpeed) {
                        Vec3 capped = movement.normalize().scale(maxSpeed);
                        this.mob.setDeltaMovement(capped.x, movement.y, capped.z);
                    }
                } else {
                    this.mob.setZza(0.0f);
                    Vec3 motion = this.scarab.getDeltaMovement();
                    this.scarab.setDeltaMovement(motion.multiply(0.9, 0.9, 0.9));
                }
            } else {
                super.tick();
            }
        }
    }

    static class BeetleMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Scarab scarab;
        private int ramCooldown = 0;
        private int flyAttemptCooldown = 0;

        public BeetleMeleeAttackGoal(Scarab scarab, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)scarab, speedModifier, followingTargetEvenIfNotSeen);
            this.scarab = scarab;
        }

        public void tick() {
            super.tick();
            if (this.scarab.getTarget() != null) {
                if (!this.scarab.isEmbellished() && !this.scarab.isFlying() && --this.ramCooldown <= 0 && this.scarab.distanceToSqr((Entity)this.scarab.getTarget()) < 10.0 && this.scarab.random.nextInt(20) == 0) {
                    Vec3 toTarget = this.scarab.getTarget().position().subtract(this.scarab.position()).normalize();
                    this.scarab.setDeltaMovement(toTarget.scale(0.8));
                    this.ramCooldown = 60;
                }
                if (this.scarab.isEmbellished() && !this.scarab.isFlying() && !this.scarab.isLanding() && --this.flyAttemptCooldown <= 0) {
                    if (this.scarab.random.nextInt(100) < 20) {
                        this.scarab.setFlying(true);
                    }
                    this.flyAttemptCooldown = 20;
                }
            }
        }
    }

    static class BeetleRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        protected final Scarab scarab;

        public BeetleRandomStrollGoal(Scarab scarab, double speedModifier) {
            super((PathfinderMob)scarab, speedModifier);
            this.scarab = scarab;
        }

        @Nullable
        protected Vec3 getPosition() {
            if (this.scarab.isFlying()) {
                Vec3 forward = this.mob.getViewVector(0.0f);
                Vec3 upward = new Vec3(0.0, 1.0, 0.0);
                Vec3 right = forward.cross(upward).normalize();
                forward = forward.scale(this.mob.getRandom().nextDouble() * 8.0);
                upward = upward.scale(this.mob.getRandom().nextDouble() * 2.0 - 1.0);
                right = right.scale(this.mob.getRandom().nextDouble() * 4.0 - 2.0);
                Vec3 target = this.mob.position().add(forward).add(upward).add(right);
                int minY = this.mob.level().getMinBuildHeight() + 5;
                if (target.y < (double)minY) {
                    target = new Vec3(target.x, (double)minY, target.z);
                }
                return target;
            }
            if (this.mob.isInWaterOrBubble()) {
                Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
                return vec3 == null ? super.getPosition() : vec3;
            }
            return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7) : super.getPosition();
        }

        public boolean canUse() {
            Vec3 vec3;
            if (!this.forceTrigger) {
                if (this.mob.getNoActionTime() >= 100) {
                    return false;
                }
                if (this.mob.getRandom().nextInt(BeetleRandomStrollGoal.reducedTickDelay((int)this.interval)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.getPosition()) == null) {
                return false;
            }
            this.wantedX = vec3.x;
            this.wantedY = vec3.y;
            this.wantedZ = vec3.z;
            this.forceTrigger = false;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.scarab.isFlying()) {
                return this.mob.getNavigation().isInProgress() && this.mob.distanceToSqr(this.wantedX, this.wantedY, this.wantedZ) > 2.0;
            }
            return super.canContinueToUse();
        }
    }
}

